<?php

// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// ##################### DEFINE IMPORTANT CONSTANTS #######################
define('THIS_SCRIPT', 'referrers'); 

// #################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array();

// get special data templates from the datastore
$specialtemplates = array();

// pre-cache templates used by all actions
$globaltemplates = array(
        'REFERRERS',
        'refbit',
		'pagenav',
);

// pre-cache templates used by specific actions
$actiontemplates = array();

// ########################## REQUIRE BACK-END ############################
require_once('./global.php');

// #################### HARD CODE JAVASCRIPT PATHS ########################
$headinclude = str_replace('"clientscript', '"' . $vbulletin->options['bburl'] . '/clientscript', $headinclude);

// ########################################################################
// ######################### START MAIN SCRIPT ############################
// ########################################################################
global $vbulletin;

$navbits = array(); 
// title of the page that is displayed in the navbar
$navbits[$parent] = ' ';

//check permissions
$temp = str_replace(" ","",$vbulletin->options['refstats_permissions']);
if($permitted_usergroups = explode(",", $temp)) {
	foreach($permitted_usergroups as $value) {
 		if(is_member_of($vbulletin->userinfo, $value)) print_no_permission();
	}
}
//check date limit and format it
if($vbulletin->options['refstats_datecutoff']==0) {
$cutoff=0; }
else {
$array_date = explode("-",$vbulletin->options['refstats_datecutoff']);
$cutoff= mktime(0,0,0,$array_date[1],$array_date[0],$array_date[2]);
}
//pagenav
$vbulletin->input->clean_array_gpc('r', array(
        'perpage' => TYPE_INT,
        'page' => TYPE_INT
    ));

    $perpage = $vbulletin->options['refstats_perpage'];
    $pagenumber = $vbulletin->GPC['page'];        
    if(empty($vbulletin->GPC['page']))
        $page = 1;
    else
        $page = $vbulletin->GPC['page'];

//get the arrays we want
//referrer_array: referrers
 $getreferrers_query = $db->query_read("select distinct user1.userid, user1.usergroupid, user1.username, user1.joindate, user1.posts, user1.referrerid from " . TABLE_PREFIX . "user AS user1 INNER JOIN " . TABLE_PREFIX ."user AS user2 ON user1.userid = user2.referrerid;");

 while ($userinfo = $db->fetch_array($getreferrers_query))
 {
	 $referrer_array['username']["$userinfo[userid]"] = $userinfo['username'];
	 $referrer_array['usergroupid']["$userinfo[userid]"] = $userinfo['usergroupid'];
	 $referrer_array['referrerid']["$userinfo[userid]"] = $userinfo['referrerid'];
	 $referrer_array['joindate']["$userinfo[userid]"] = $userinfo['joindate'];
	 $referrer_array['posts']["$userinfo[userid]"] = $userinfo['posts'];
 }
 

//referral_array: referrals
 $getreferrals_query = $db->query_read("select distinct userid, usergroupid, username, joindate, posts, referrerid from " . TABLE_PREFIX . "user WHERE referrerid > 0;");

 while ($userinfo = $db->fetch_array($getreferrals_query))
 {
     $referral_array['username']["$userinfo[userid]"] = $userinfo['username'];
	 $referral_array['usergroupid']["$userinfo[userid]"] = $userinfo['usergroupid'];
	 $referral_array['referrerid']["$userinfo[userid]"] = $userinfo['referrerid'];
	 $referral_array['joindate']["$userinfo[userid]"] = $userinfo['joindate'];
	 $referral_array['posts']["$userinfo[userid]"] = $userinfo['posts'];
 }

//##### woo hoo we got the arrays, now let's use them #####
//cut off the data according to the cut off date
foreach($referrer_array['joindate'] as $key=>$value) {
	if ($value<$cutoff) {
		unset($referrer_array['username'][$key]);
	 	unset($referrer_array['usergroupid'][$key]);
	 	unset($referrer_array['referrerid'][$key]);
	}
}
foreach($referral_array['joindate'] as $key=>$value) {
	if ($value<$cutoff) {
		unset($referral_array['username'][$key]);
	 	unset($referral_array['usergroupid'][$key]);
	 	unset($referral_array['referrerid'][$key]);
	}
}
unset ($referrer_array['joindate']);
unset ($referral_array['joindate']);

//exclude bad usergroups
$temp = str_replace(" ","",$vbulletin->options['refstats_badgroups']);
if($bad_usergroups = explode(",", $temp)) {
	foreach($bad_usergroups as $bad_usergroupid) {
 		foreach ($referrer_array['usergroupid'] as $key=>$value) {
			if ($value==$bad_usergroupid) {
				unset($referrer_array['username'][$key]);
	 			unset($referrer_array['usergroupid'][$key]);
	 			unset($referrer_array['referrerid'][$key]);
			}
		}	
 		foreach ($referral_array['usergroupid'] as $key=>$value) {
			if ($value==$bad_usergroupid) {
				unset($referral_array['username'][$key]);
	 			unset($referral_array['usergroupid'][$key]);
	 			unset($referral_array['referrerid'][$key]);
			}
		}
	}
}
unset($temp);
if(count($referral_array['username'])) { //check if there are any results
//ref_num: input: userid, output: total number of referrals for that userid
//ref_names_array input: userid, output: all the referred usernames as a string
foreach ($referrer_array['username'] as $key=>$value) {
	$ref_num[$key]=0;
	foreach ($referral_array['referrerid'] as $key2=>$value2)  
		if ($value2==$key) { 
		 	$ref_num[$key]++;
			if($vbulletin->options['refstats_showposts']){
				$referralposts = "(" . construct_phrase($vbphrase['posts']) . ": " . $referral_array['posts'][$key2] . ")"; }
			else { $referralposts = ""; }
			$ref_names[$key] = $ref_names[$key] . "<a href=\"member.php?u=$key2\" rel=\"nofollow\">" . $vbulletin->usergroupcache[$referral_array['usergroupid'][$key2]]['opentag'] . $referral_array['username'][$key2] . $vbulletin->usergroupcache[$referral_array['usergroupid'][$key2]]['closetag'] . "</a>" . $referralposts . ", ";			
		};
	$ref_names[$key] = substr($ref_names[$key],0,strlen($ref_names[$key])-2);
}

//page navigation
if(count($ref_num)>$perpage) {
$pagenav = construct_page_nav($page, $perpage, count($ref_num), "referrers.php?",""); }

//referrer_name: input: userid output: formatted username
$referrer_name=$referrer_array['username'];
foreach ($referrer_name as $key=>$value) $referrer_name[$key] = $vbulletin->usergroupcache[$referrer_array['usergroupid'][$key]]['opentag'] . $referrer_name[$key] . $vbulletin->usergroupcache[$referrer_array['usergroupid'][$key]]['closetag'];

//graph
if($vbulletin->options['refstats_pollcolors']==0) $color=rand(1,6);

//find the maximum value of referral count
$maxrefs=$ref_num[1];
foreach($ref_num as $key=>$value)	{
if($maxrefs < $ref_num[$key]) $maxrefs=$ref_num[$key];
}
if($vbulletin->options['refstats_showposts']){
//referrerposts: input: userid, output: member's posts. Just for the template actually since it can't handle 2D arrays
$referrerposts=$referrer_array['posts'];
}

$i=0; //initialize values
$j=1; //initialize values
arsort($ref_num);
foreach($ref_num as $key=>$value)	{
	$i++; //i is the number of each repeat
	if($i==1) $prev_value=$value;
    if($prev_value>$value){
		$j++; //j outputs the rank of the referrer (shown on first column)
	}
	$prev_value=$value;
	$graphwidth = 200 * ($ref_num[$key]/$maxrefs); //find the width for each bar of the graphical representeation
	if($vbulletin->options['refstats_pollcolors']==1) $color=($i % 5)+1; //color for the graphical representation
	if (($i>(($page-1)*$perpage)) AND ($i<($page*$perpage+1))) { //check if the output should be displayed or not according to page #
		eval('$refbits .= "' . fetch_template('refbit') . '";'); }

}
}
$navbits = construct_navbits($navbits);
eval('$navbar = "' . fetch_template('navbar') . '";');

//actual main output template
eval('print_output("' . fetch_template('REFERRERS') . '");');
?> 
